import requests
import scipy
import numpy as np
import os

def download_file(path, folder_name, filename):
    """Download a file from a given URL and save it to the specified path.

    :param path: Path where the file should be saved.
    :param folder_name: Name of the folder containing the file on the server.
    :param filename: Name of the file to be downloaded.
    """

    path = os.path.join(path, filename)

    url = f"https://storage.googleapis.com/pinns/{folder_name}/{filename}"
    response = requests.get(url, timeout=10)
    if response.status_code == 200:
        os.makedirs(os.path.dirname(path), exist_ok=True)
        with open(path, "wb") as file:
            file.write(response.content)
        print("File Download Successful.")
    else:
        print("File download failed.")


########################################


if __name__ == "__main__":
    root_path = "Dataset Creation\Pinnacle Data"
    os.makedirs(root_path, exist_ok=True)

    ## Discrete Forward Allen-Cahn Equation: Non-linear AC
    # download_file(root_path, "data",  "AC.mat")

    ## Continuous Forward 3D Navier-Stokes Equation
    # download_file(root_path, "data", "Aneurysm3D.mat") ## Long Time No Response

    ## Continuous (discrete) Forward/Inverse Burgers' Equation
    # download_file(root_path, "data",  "burgers_shock.mat")

    ## Discrete Inverse Korteweg–de Vries Equation
    # download_file(root_path, "data",  "KdV.mat")

    ## Continuous Inverse Navier-Stokes Equation
    # download_file(root_path, "data",  "cylinder_nektar_wake.mat")

    ## Continuous Forward Schrodinger Equation
    # download_file(root_path, "data",  "NLS.mat")